//================================================================================
// TheDanes Skinmanager
//================================================================================
class DanesSkinManager expands Mutator config(DanesSkinManagerV2);

var string Players[32], Models[32];
var int Modded[32];
var int ii;

var config bool bLogEnabled;
var config string ClanTag1, ClanTag2;
var config int MaleClanModel1, MaleClanModel2, FemaleClanModel1, FemaleClanModel2, MaleGuestModel, FemaleGuestModel;
var config string MaleClanSkin1, MaleClanFace1, FemaleClanSkin1, FemaleClanFace1;
var config string MaleClanSkin2, MaleClanFace2, FemaleClanSkin2, FemaleClanFace2;
var config string MaleGuestSkin, MaleGuestFace, FemaleGuestSkin, FemaleGuestFace;

function string ParseOption( string Options, string InKey )
{
	local string Pair, Key, Value;
	while( GrabOption( Options, Pair ) )
	{
		GetKeyValue( Pair, Key, Value );
		if( Key ~= InKey )
			return Value;
	}
	return "";
}

function bool GrabOption( out string Options, out string Result )
{
	if( Left(Options,1)=="?" )
	{
		// Get result.
		Result = Mid(Options,1);
		if( InStr(Result,"?")>=0 )
			Result = Left( Result, InStr(Result,"?") );

		// Update options.
		Options = Mid(Options,1);
		if( InStr(Options,"?")>=0 )
			Options = Mid( Options, InStr(Options,"?") );
		else
			Options = "";

		return true;
	}
	else return false;
}

function int GetIntOption( string Options, string ParseString, int CurrentValue)
{
	local string InOpt;

	InOpt = ParseOption( Options, ParseString );
	if ( InOpt != "" )
	{
		log(ParseString@InOpt);
		return int(InOpt);
	}	
	return CurrentValue;
}

function GetKeyValue( string Pair, out string Key, out string Value )
{
	if( InStr(Pair,"=")>=0 )
	{
		Key   = Left(Pair,InStr(Pair,"="));
		Value = Mid(Pair,InStr(Pair,"=")+1);
	}
	else
	{
		Key   = Pair;
		Value = "";
	}
}

function ModifyLogin (out Class<PlayerPawn> SpawnClass, out string Portal, out string Options)
{

	local int i;
	local string InName, InPassword, InSkin, InFace, InChecksum;
	local int InTeam;
	local PlayerPawn NewPlayer;

	Super.ModifyLogin(SpawnClass, Portal, Options);

	// Get URL options.
	InName     = Left(ParseOption ( Options, "Name"), 20); // Playername som virker yehaw!!
	InTeam     = GetIntOption( Options, "Team", 255 ); // default to "no team"
	InSkin	   = ParseOption ( Options, "Skin"    );
	InFace     = ParseOption ( Options, "Face"    );
	
	// test om alle oplysninger er korrekte
	if ( bLogEnabled )
		{
		log("--------------------------------");
		log("- TheDanes Skin Manager v2     -");
		log("- Assigning model part         -");
		log("--------------------------------");
		log("PlayerName: "@InName);
		log("PlayerTeam: "@InTeam);
		log("SpawnClass: "@SpawnClass);
		log("SpawnSkin : "@InSkin);
		log("SpawnFace : "@InFace);
		}

	// put playernavn p templisten og gem ii som referent til slot nummer
	for ( i=0; i<32; i++ )
		{
		if (( InName == Players[i] ) || ( Players[i] == "" ))
			{
			Players[i] = InName;
			ii = i; // videre players slot nummer til skin function
			i = 200; // kill loop
			}
		}

	
	// her skal player s modificeres ud fra InName som PlayerName, kig i GameInfo scriptet for mulighedder.

	// check om player er clan medlem af clan 1
	if ((InStr(InName, ClanTag1) != -1) && (ClanTag1 != ""))
		{
		// player is member of clan1
		if (( SpawnClass != class'BotPack.TFemale1' ) && ( SpawnClass != class'BotPack.TFemale2' ))
			{
			if ( MaleClanModel1 == 1 )
				{
				SpawnClass = class'Botpack.TMale1';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleClanModel1 == 2 )
				{
				SpawnClass = class'Botpack.TMale2';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleClanModel1 == 3 )
				{
				SpawnClass = class'Botpack.TBoss';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleClanModel1 == 4 )
				{
				SpawnClass = class'BotPack.TFemale1';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleClanModel1 == 5 )
				{
				SpawnClass = class'BotPack.TFemale2';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleClanModel1 == 6 )
				{
				SpawnClass = class'MultiMesh.TNali';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleClanModel1 == 7 )
				{
				SpawnClass = class'MultiMesh.TCow';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleClanModel1 == 8 )
				{
				SpawnClass = class'MultiMesh.TSkaarj';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else
				{
				log("ERROR     :  unsupported model assigned for ClanTag1 male players, check your ini settings!");
				}
			Models[ii] = "MaleClan1";
			Modded[ii] = 1;
			if ( bLogEnabled )
				{
				log("Group     :  Player assigned to male ClanTag1 group");
				log("--------------------------------");
				}
			}
		else
			{
			if ( FemaleClanModel1 == 1 )
				{
				SpawnClass = class'Botpack.TMale1';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleClanModel1 == 2 )
				{
				SpawnClass = class'Botpack.TMale2';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleClanModel1 == 3 )
				{
				SpawnClass = class'Botpack.TBoss';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleClanModel1 == 4 )
				{
				SpawnClass = class'BotPack.TFemale1';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleClanModel1 == 5 )
				{
				SpawnClass = class'BotPack.TFemale2';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleClanModel1 == 6 )
				{
				SpawnClass = class'MultiMesh.TNali';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleClanModel1 == 7 )
				{
				SpawnClass = class'MultiMesh.TCow';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleClanModel1 == 8 )
				{
				SpawnClass = class'MultiMesh.TSkaarj';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else
				{
				log("ERROR     :  unsupported model assigned for ClanTag1 female players, check your ini settings!");
				}
			Models[ii] = "FemaleClan1";
			Modded[ii] = 1;
			if ( bLogEnabled )
				{
				log("Group     :  Player assigned to female ClanTag1 group");
				log("--------------------------------");
				}
			}
		}

	// check om player er clan medlem af clan 2
	else if ((InStr(InName, ClanTag2) != -1) && (ClanTag2 != ""))
		{
		// player is member of clan2
		if (( SpawnClass != class'BotPack.TFemale1' ) && ( SpawnClass != class'BotPack.TFemale2' ))
			{
			if ( MaleClanModel2 == 1 )
				{
				SpawnClass = class'Botpack.TMale1';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleClanModel2 == 2 )
				{
				SpawnClass = class'Botpack.TMale2';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleClanModel2 == 3 )
				{
				SpawnClass = class'Botpack.TBoss';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleClanModel2 == 4 )
				{
				SpawnClass = class'BotPack.TFemale1';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleClanModel2 == 5 )
				{
				SpawnClass = class'BotPack.TFemale2';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleClanModel2 == 6 )
				{
				SpawnClass = class'MultiMesh.TNali';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleClanModel2 == 7 )
				{
				SpawnClass = class'MultiMesh.TCow';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleClanModel2 == 8 )
				{
				SpawnClass = class'MultiMesh.TSkaarj';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else
				{
				log("ERROR     :  unsupported model assigned for ClanTag2 male players, check your ini settings!");
				}
			Models[ii] = "MaleClan2";
			Modded[ii] = 1;
			if ( bLogEnabled )
				{
				log("Group     :  Player assigned to male ClanTag2 group");
				log("--------------------------------");
				}
			}
		else
			{
			if ( FemaleClanModel2 == 1 )
				{
				SpawnClass = class'Botpack.TMale1';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleClanModel2 == 2 )
				{
				SpawnClass = class'Botpack.TMale2';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleClanModel2 == 3 )
				{
				SpawnClass = class'Botpack.TBoss';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleClanModel2 == 4 )
				{
				SpawnClass = class'BotPack.TFemale1';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleClanModel2 == 5 )
				{
				SpawnClass = class'BotPack.TFemale2';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleClanModel2 == 6 )
				{
				SpawnClass = class'MultiMesh.TNali';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleClanModel2 == 7 )
				{
				SpawnClass = class'MultiMesh.TCow';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleClanModel2 == 8 )
				{
				SpawnClass = class'MultiMesh.TSkaarj';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else
				{
				log("ERROR     :  unsupported model assigned for ClanTag2 female players, check your ini settings!");
				}
			Models[ii] = "FemaleClan2";
			Modded[ii] = 1;
			if ( bLogEnabled )
				{
				log("Group     :  Player assigned to female ClanTag2 group");
				log("--------------------------------");
				}
			}
		}

	// player er ikke clan1 eller clan2, s player er guest
	else
		{
		// player is a guest
		if (( SpawnClass != class'BotPack.TFemale1' ) && ( SpawnClass != class'BotPack.TFemale2' ))
			{
			if ( MaleGuestModel == 1 )
				{
				SpawnClass = class'Botpack.TMale1';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleGuestModel == 2 )
				{
				SpawnClass = class'Botpack.TMale2';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleGuestModel == 3 )
				{
				SpawnClass = class'Botpack.TBoss';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleGuestModel == 4 )
				{
				SpawnClass = class'BotPack.TFemale1';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleGuestModel == 5 )
				{
				SpawnClass = class'BotPack.TFemale2';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleGuestModel == 6 )
				{
				SpawnClass = class'MultiMesh.TNali';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleGuestModel == 7 )
				{
				SpawnClass = class'MultiMesh.TCow';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( MaleGuestModel == 8 )
				{
				SpawnClass = class'MultiMesh.TSkaarj';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else
				{
				log("ERROR     :  unsupported model assigned for male guest players, check your ini settings!");
				}
			Models[ii] = "MaleGuest";
			Modded[ii] = 1;
			if ( bLogEnabled )
				{
				log("Group     :  Player assigned to male guests group");
				log("--------------------------------");
				}
			}
		else
			{
			if ( FemaleGuestModel == 1 )
				{
				SpawnClass = class'Botpack.TMale1';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleGuestModel == 2 )
				{
				SpawnClass = class'Botpack.TMale2';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleGuestModel == 3 )
				{
				SpawnClass = class'Botpack.TBoss';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleGuestModel == 4 )
				{
				SpawnClass = class'BotPack.TFemale1';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleGuestModel == 5 )
				{
				SpawnClass = class'BotPack.TFemale2';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleGuestModel == 6 )
				{
				SpawnClass = class'MultiMesh.TNali';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleGuestModel == 7 )
				{
				SpawnClass = class'MultiMesh.TCow';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else if ( FemaleGuestModel == 8 )
				{
				SpawnClass = class'MultiMesh.TSkaarj';
				if ( bLogEnabled )
					{
					log("New Class : "@SpawnClass);
					}
				}
			else
				{
				log("ERROR     :  unsupported model assigned for female guest players, check your ini settings!");
				}
			Models[ii] = "FemaleGuest";
			Modded[ii] = 1;
			if ( bLogEnabled )
				{
				log("Group     :  Player assigned to female guests group");
				log("--------------------------------");
				}
			}
		}
	if ( NextMutator != None )
		{
		NextMutator.ModifyLogin(SpawnClass,Portal,Options);
		}
}

// MaleClan1, MaleClan2, FemaleClan1, FemaleClan2, MaleGuest, FemaleGuest

function ModifyPlayer(Pawn Other)
{
	local int iTeam, i;
	local string Spillernavn;

	iTeam = Other.PlayerReplicationInfo.Team;
	Spillernavn = Other.PlayerReplicationInfo.PlayerName;

	for ( i=0; i<32; i++ )
		{
		if ( Spillernavn == Players[i] )
			{
			if (( Models[i] == "MaleClan1" ) && ( Modded[i] == 1 ))
				{	
				Other.SetMultiSkin(Other, ""$MaleClanSkin1, ""$MaleClanFace1, iTeam);
				if ( bLogEnabled )
					{
					log("--------------------------------");
					log("- TheDanes Skin Manager v2     -");
					log("- Assigning new skins part     -");
					log("--------------------------------");
					log("Player    : "$Players[i]);
					log("New Skin  : "$MaleClanSkin1);
					log("New Face  : "$MaleClanFace1);
					log("--------------------------------");
					}
				Players[i] = "";
				Modded[i] = 0;
				}
			else if (( Models[i] == "MaleClan2" ) && ( Modded[i] == 1 ))
				{	
				Other.SetMultiSkin(Other, ""$MaleClanSkin2, ""$MaleClanFace2, iTeam);
				if ( bLogEnabled )
					{
					log("--------------------------------");
					log("- TheDanes Skin Manager v2     -");
					log("- Assigning new skins part     -");
					log("--------------------------------");
					log("Player    : "$Players[i]);
					log("New Skin  : "$MaleClanSkin2);
					log("New Face  : "$MaleClanFace2);
					log("--------------------------------");
					}
				Players[i] = "";
				Modded[i] = 0;
				}
			else if (( Models[i] == "FemaleClan1" ) && ( Modded[i] == 1 ))
				{	
				Other.SetMultiSkin(Other, ""$FemaleClanSkin1, ""$FemaleClanFace1, iTeam);
				if ( bLogEnabled )
					{
					log("--------------------------------");
					log("- TheDanes Skin Manager v2     -");
					log("- Assigning new skins part     -");
					log("--------------------------------");
					log("Player    : "$Players[i]);
					log("New Skin  : "$FemaleClanSkin1);
					log("New Face  : "$FemaleClanFace1);
					log("--------------------------------");
					}
				Players[i] = "";
				Modded[i] = 0;
				}
			else if (( Models[i] == "FemaleClan2" ) && ( Modded[i] == 1 ))
				{	
				Other.SetMultiSkin(Other, ""$FemaleClanSkin2, ""$FemaleClanFace2, iTeam);
				if ( bLogEnabled )
					{
					log("--------------------------------");
					log("- TheDanes Skin Manager v2     -");
					log("- Assigning new skins part     -");
					log("--------------------------------");
					log("Player    : "$Players[i]);
					log("New Skin  : "$FemaleClanSkin2);
					log("New Face  : "$FemaleClanFace2);
					log("--------------------------------");
					}
				Players[i] = "";
				Modded[i] = 0;
				}
			else if (( Models[i] == "MaleGuest" ) && ( Modded[i] == 1 ))
				{	
				Other.SetMultiSkin(Other, ""$MaleGuestSkin, ""$MaleGuestFace, iTeam);
				if ( bLogEnabled )
					{
					log("--------------------------------");
					log("- TheDanes Skin Manager v2     -");
					log("- Assigning new skins part     -");
					log("--------------------------------");
					log("Player    : "$Players[i]);
					log("New Skin  : "$MaleGuestSkin);
					log("New Face  : "$MaleGuestFace);
					log("--------------------------------");
					}
				Players[i] = "";
				Modded[i] = 0;
				}
			else if (( Models[i] == "FemaleGuest" ) && ( Modded[i] == 1 ))
				{	
				Other.SetMultiSkin(Other, ""$FemaleGuestSkin, ""$FemaleGuestFace, iTeam);
				if ( bLogEnabled )
					{
					log("--------------------------------");
					log("- TheDanes Skin Manager v2     -");
					log("- Assigning new skins part     -");
					log("--------------------------------");
					log("Player    : "$Players[i]);
					log("New Skin  : "$FemaleGuestSkin);
					log("New Face  : "$FemaleGuestFace);
					log("--------------------------------");
					}
				Players[i] = "";
				Modded[i] = 0;
				}
			else
				{
				log("--------------------------------");
				log("- TheDanes Skin Manager v2     -");
				log("- Assigning new skins part     -");
				log("--------------------------------");
				log("Player    : "$Players[i]);
				log("ERROR     :  Failed to detect player model, multiskins could not be spawned - check ini settings.");
				Players[i] = "";
				Modded[i] = 0;
				}
			}
			Super.ModifyPlayer(Other);
		}
}


